#include "pch.h"
#include "Mem.hpp"
#include "Misc.hpp"
#include "Temp.hpp"
#include "Common.hpp"
#include "File.h"
#include "Adrenalin.h"
#include "Msg.hpp"


CMsg::CMsg() : m_MsgIdHandler() {
	TCHAR	szFindFileMask[MAX_PATH];

	::FillMemory( &m_Header, sizeof(m_Header), 0 );
	*m_szArea      = _T('\0');
	*m_szMsgIdLine = _T('\0');
	m_wAttrs = 0;

	lstrcpy( szFindFileMask, g_vars.m_szNetmailPath );
	lstrcat( szFindFileMask, _T("*.msg") );
	m_lFreeMsgNumber = GetFreeDirNumber( szFindFileMask );

	m_hFile = INVALID_HANDLE_VALUE;
}


CMsg::~CMsg() {
	if (m_hFile != INVALID_HANDLE_VALUE) {
		CloseHandle( m_hFile );
		m_hFile = INVALID_HANDLE_VALUE;
	}
}


static TCHAR	userNameWithoutBoundarySpaces[36];

bool CMsg::Read(LPCTSTR szMsgFName) {
	DWORD		dwBytesRead;
	int		iBufPos, iCurPos;
	int		i, j;
	static char	szOemKludge[MAX_KLUDGE_SIZE];
	static TCHAR	szKludge[MAX_KLUDGE_SIZE];
	bool		fMiddleOfLine;
	bool		fMiddleOfKludge;
	char		cKludgeType; // 0x01, '%', '+', '-'
  
	*m_szArea        = _T('\0');
	m_wFlags         = 0;

	m_fFlagsPresent = false;
	m_vFlags.clear();

	m_fFMPTPresent   = false;
	m_fTOPTPresent   = false;
	m_fINTLPresent   = false;
	m_fDOMAINPresent = false;
	m_fMsgIdPresent  = false;
	m_fMsgIdDecoded  = false;

	g_vars.m_vMsgData.clear();

	// keep message file name and message directory
	lstrcpy( m_szMsgFileName, szMsgFName );
	j = -1;
	for (i = 0; szMsgFName[i] != _T('\0'); i++) {
		if (szMsgFName[i] == _T('\\'))
			j = i;
	}
	j++;
	lstrcpyn( m_szMsgFileDir, szMsgFName, j+1 );

	// open file
	m_hFile = CreateFile( szMsgFName, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL );
	if (m_hFile == INVALID_HANDLE_VALUE)
		return (false);

	// read header
	if (!ReadFile( m_hFile, &m_Header, sizeof(m_Header), &dwBytesRead, NULL ) ||
		dwBytesRead != sizeof(m_Header))
	{
		CloseFile();
		return (false);
	}

	m_wAttrs = m_Header.m_wAttrs;

	// skip the message with RECEIVED attribute
	if (m_wAttrs & ATTR_RECEIVED) {
		CloseFile();
		return (false);
	}

	// keep names and subject
	m_Header.m_szToUserName[MSG_NAME_LENGTH-1]   = '\0';
	m_Header.m_szFromUserName[MSG_NAME_LENGTH-1] = '\0';
	m_Header.m_szSubject[MSG_SUBJECT_LENGTH-1]   = '\0';
	OemToChar( m_Header.m_szToUserName,   m_szToUserName   );
	OemToChar( m_Header.m_szFromUserName, m_szFromUserName );
	OemToChar( m_Header.m_szSubject,      m_szSubject    );

	// check addressee
	removeBoundarySpaces( m_szToUserName, userNameWithoutBoundarySpaces );
	for (i = 0; i < g_vars.m_vsAliases.size(); i++) {
		if (lstrcmpi( userNameWithoutBoundarySpaces, g_vars.m_vsAliases[i].c_str() ) == 0) {
			lstrcpy( m_szToUserName, g_vars.m_vsAliases[i].c_str() );
			CharToOem( m_szToUserName, m_Header.m_szToUserName );
			break;
		}
	}
	if (i >= g_vars.m_vsAliases.size()) {
		CloseFile();
		return (false);
	}

	// request memory for message

	DWORD	dwBodySize = ::GetFileSize( m_hFile, NULL );
	if (dwBodySize == 0xFFFFFFFF) {
		// error
		CloseFile();
		return (false);
	}
	dwBodySize -= sizeof(m_Header);
	m_arrMessage.RequestCapacity( dwBodySize );

	// get a pointer on the requested memory
	BYTE*	arrbMessage = m_arrMessage.Get();
	// read message body
	if (!ReadFile( m_hFile, arrbMessage, dwBodySize, &dwBytesRead, NULL ) ||
	    dwBytesRead != dwBodySize)
	{
		// error
		CloseFile();
		return (false);
	}
    
	m_dwBodySize = dwBodySize;

	iBufPos         = 0;
	fMiddleOfLine   = false;
	fMiddleOfKludge = false;
	m_fMsgInBuf = true;
	if (dwBodySize > 5) {
		if (strncmp( (const char*)arrbMessage, "AREA:", 5 ) == 0) {
			iBufPos += 5;
			i = 0;
			while (iBufPos < dwBodySize && i < (MAX_AREA_SIZE-1)
				&& arrbMessage[iBufPos] != 0x0D)
			{
				iBufPos++;
				i++;
			}
			if (i > 0) {
				TCHAR	szOemArea[MAX_AREA_SIZE];
				::CopyMemory( szOemArea, arrbMessage, i );
				szOemArea[i] = '\0';
				OemToChar( szOemArea, m_szArea );
			}
			while (iBufPos < dwBodySize && arrbMessage[iBufPos] != 0x0D)
				iBufPos++;
			if (iBufPos < dwBodySize) // 0x0D
				iBufPos++;
			else
				fMiddleOfLine = true;
		}
	}
	while (iBufPos < dwBodySize) {
		if (fMiddleOfKludge) {
			j = i;
			iCurPos = iBufPos;
			while (iBufPos < dwBodySize && i < (MAX_KLUDGE_SIZE-1)
				&& arrbMessage[iBufPos] != 0x0D)
			{
				iBufPos++;
				i++;
			}
			if (i > j) {
				::CopyMemory( arrbMessage+iCurPos, szOemKludge+j, i-j );
				szOemKludge[i] = '\0';
				OemToChar( szOemKludge, szKludge );
				if (!(iBufPos == dwBodySize && i < (MAX_KLUDGE_SIZE-1))) {
					fMiddleOfKludge = false;
					ProcessLine( cKludgeType, szKludge );
				}
			}
		}
		else if (fMiddleOfLine) {
			while (iBufPos < dwBodySize && arrbMessage[iBufPos] != 0x0D)
				iBufPos++;
			if (iBufPos < dwBodySize) { // 0x0D
				iBufPos++;
				if (iBufPos < dwBodySize && arrbMessage[iBufPos] == 0x0A)
					iBufPos++;
				fMiddleOfLine = false;
			}
		}
		else {
			cKludgeType = arrbMessage[iBufPos];
			if (cKludgeType == 0x01 || cKludgeType == '%' ||
				cKludgeType == '+'  || cKludgeType == '-')
			{
				iBufPos++;
				i = 0;
				iCurPos = iBufPos;
				while (iBufPos < dwBodySize && i < (MAX_KLUDGE_SIZE-1)
					&& arrbMessage[iBufPos] != 0x0D)
				{
					iBufPos++;
					i++;
				}
				if (i > 0 || iBufPos == dwBodySize) {
					if (i > 0) {
						::CopyMemory( szOemKludge, arrbMessage+iCurPos, i );
						szOemKludge[i] = '\0';
						OemToChar( szOemKludge, szKludge );
						if (iBufPos == dwBodySize && i < (MAX_KLUDGE_SIZE-1))
							fMiddleOfKludge = true;
						else {
							ProcessLine( cKludgeType, szKludge );
						}
					}
				}
			}
			while (iBufPos < dwBodySize && arrbMessage[iBufPos] != 0x0D)
				iBufPos++;
			if (iBufPos < dwBodySize) { // 0x0D
				iBufPos++;
				if (iBufPos < dwBodySize && arrbMessage[iBufPos] == 0x0A)
					iBufPos++;
			}
			else {
				if (!fMiddleOfKludge)
					fMiddleOfLine = true;
			}
		}
	}
    
	if (fMiddleOfKludge) {
		ProcessLine( cKludgeType, szKludge );
	}
    
	DecodeAddresses();

	// check if message to our address or not
	bool	fToProcessor = false;
	if (ToAddr( g_vars.m_addrMain ))
		fToProcessor = true;
	for (i = 0; i < g_vars.m_vAKAAddr.size(); i++) {
		if (ToAddr( g_vars.m_vAKAAddr[i] )) {
			fToProcessor = true;
			break;
		}
	}
	if (!fToProcessor) {
		g_vars.m_vMsgData.clear();
		CloseFile();
		return (false);
	}

	/*
	cout << "Msg from " << From.Zone << ":" << From.Net << "/" << From.Node
		<< "." << From.Point << " to " << To.Zone << ":" << To.Net << "/"
		<< To.Node << "." << To.Point << endl;
	*/

	return (true);
}


/**
 * Process message line
 */
void CMsg::ProcessLine(TCHAR kludgeTypeChar, LPTSTR lineData) {

	int	j;

	switch (kludgeTypeChar) {
	case TEXT('\1'):
		// check kludges
		if (!m_fFMPTPresent && _tcsncmp( lineData, _T("FMPT "), 5) == 0) {
			if (ParsePT( lineData+5, m_wFMPT ))
				m_fFMPTPresent = true;
		}
		else if (!m_fTOPTPresent && _tcsncmp( lineData, _T("TOPT "), 5) == 0) {
			if (ParsePT( lineData+5, m_wTOPT ))
				m_fTOPTPresent = true;
		}
		else if (!m_fINTLPresent && _tcsncmp( lineData, _T("INTL "), 5) == 0) {
			if (ParseINTL( lineData+5 ))
				m_fINTLPresent = true;
		}
		else if (!m_fFlagsPresent && _tcsncmp( lineData, _T("FLAGS "), 6) == 0) {
			if (ParseFlags( lineData+6 ))
				m_fFlagsPresent = true;
		}
		else if (!m_fDOMAINPresent && _tcsncmp( lineData, _T("DOMAIN "), 7) == 0) {
			if (ParseDOMAIN( lineData+7 ))
				m_fDOMAINPresent = true;
		}
		else if (!m_fMsgIdPresent && _tcsncmp( lineData, _T("MSGID: "), 7) == 0) {
			m_fMsgIdPresent = true;
			if (ParseMsgId( lineData+7 ))
				m_fMsgIdDecoded = true;
		}
		break;
	case TEXT('%'):
		{
			j = 0;
			while (lineData[j] != TEXT('\0') && lineData[j] != TEXT(' '))
				j++;
			if (j == 0)
				break;
			SMsgData	msgData;
			msgData.m_iType = MSGDATA_COMMAND;
			msgData.m_sLine = tstring(lineData, j);
			// skip spaces
			while (lineData[j] == TEXT(' '))
				j++;
			msgData.m_sTail = tstring(lineData+j);
			g_vars.m_vMsgData.push_back( msgData );
		}
		break;
	case TEXT('+'):
		{
			j = 0;
			while (lineData[j] != TEXT('\0') && lineData[j] != TEXT(' '))
				j++;
			if (j == 0)
				break;                
			lineData[j] = TEXT('\0');
			SMsgData	msgData;
			msgData.m_sLine = lineData;
			msgData.m_iType = MSGDATA_SUBSCRIBE;
			g_vars.m_vMsgData.push_back( msgData );
		}
		break;
	case TEXT('-'):
		{
			// skip tearline
			if (lineData[0] == TEXT('-') && lineData[1] == TEXT('-'))
				break;
			j = 0;
			while (lineData[j] != TEXT('\0') && lineData[j] != TEXT(' '))
				j++;
			if (j == 0)
				break;                
			lineData[j] = _T('\0');
			SMsgData	msgData;
			msgData.m_sLine = lineData;
			msgData.m_iType = MSGDATA_UNSUBSCRIBE;
			g_vars.m_vMsgData.push_back( msgData );
		}
		break;
	}
}


void CMsg::DecodeAddresses() {
    int FromZoneDefined;
    int ToZoneDefined;

    m_fZoneGate = false;
    
    if (m_fDOMAINPresent) {
        memcpy( &m_addrFrom, &m_addrDomainKludgeFrom, sizeof(m_addrFrom) );
        memcpy( &m_addrTo,   &m_addrDomainKludgeTo, sizeof(m_addrTo) );
        return;
    }
    
    FromZoneDefined = 0;
    ToZoneDefined   = 0;
    
    m_addrFrom.Net  = m_Header.m_wOrigNet;
    m_addrFrom.Node = m_Header.m_wOrigNode;
    if (m_fFMPTPresent)
        m_addrFrom.Point = m_wFMPT;
    else
        m_addrFrom.Point = 0;
    
    m_addrTo.Net  = m_Header.m_wDestNet;
    m_addrTo.Node = m_Header.m_wDestNode;
    if (m_fTOPTPresent)
        m_addrTo.Point = m_wTOPT;
    else
        m_addrTo.Point = 0;

    if (m_fINTLPresent) {
        m_addrFrom.Zone = m_addrINTLFrom.Zone;
        FromZoneDefined = 1;
        m_addrFrom.Net  = m_addrINTLFrom.Net;
        m_addrFrom.Node = m_addrINTLFrom.Node;

        // prepare TO address
        m_addrTo.Zone = m_addrINTLTo.Zone;
        m_addrTo.Net  = m_addrINTLTo.Net;
        m_addrTo.Node = m_addrINTLTo.Node;
        ToZoneDefined = 1;

        /*
        if (m_addrTo.Net == m_addrINTLTo.Net && m_addrTo.Node == m_addrINTLTo.Node) {
            m_addrTo.Zone = m_addrINTLTo.Zone;
            ToZoneDefined = 1;
        }
        else {
            m_fZoneGate = true;
            m_addrRealTo.Zone   = m_addrINTLTo.Zone;
            m_addrRealTo.Net    = m_addrINTLTo.Net;
            m_addrRealTo.Node   = m_addrINTLTo.Node;
            m_addrRealTo.Point  = m_addrTo.Point;
            m_addrTo.Zone       = m_addrFrom.Zone;
            ToZoneDefined = 1;
            m_addrTo.Point      = 0;
        }
        */
    }
    else {
        if (m_fMsgIdDecoded)
            m_addrFrom.Zone = m_addrMsgIdFrom.Zone;
    }
    
    if (!FromZoneDefined)
        m_addrFrom.Zone = g_vars.m_addrMain.Zone;
    
    if (!ToZoneDefined)
        m_addrTo.Zone = m_addrFrom.Zone;

	if (m_fMsgIdDecoded && m_addrMsgIdFrom.Domain[0] != _T('\0'))
		lstrcpy( m_addrFrom.Domain, m_addrMsgIdFrom.Domain );
	else {
		if (m_addrFrom.Zone == g_vars.m_addrMain.Zone)
			lstrcpy( m_addrFrom.Domain, g_vars.m_addrMain.Domain );
		else {
			int	i;
			for (i = 0; i < g_vars.m_vAKAAddr.size(); i++) {
				if (m_addrFrom.Zone == g_vars.m_vAKAAddr[i].Zone) {
					lstrcpy( m_addrFrom.Domain, g_vars.m_vAKAAddr[i].Domain );
					break;
				}
			}
			if (i == g_vars.m_vAKAAddr.size())
				lstrcpy( m_addrFrom.Domain, g_vars.m_addrMain.Domain );
		}
	}

	if (m_addrTo.Zone == g_vars.m_addrMain.Zone)
		lstrcpy( m_addrTo.Domain, g_vars.m_addrMain.Domain );
	else {
		int	i;
		for (i = 0; i < g_vars.m_vAKAAddr.size(); i++) {
			if (m_addrTo.Zone == g_vars.m_vAKAAddr[i].Zone) {
				lstrcpy( m_addrTo.Domain, g_vars.m_vAKAAddr[i].Domain );
				break;
			}
		}
		if (i == g_vars.m_vAKAAddr.size())
			lstrcpy( m_addrTo.Domain, m_addrFrom.Domain );
	}
}

bool CMsg::ParsePT(LPCTSTR s, addr &PT) {
    int i; // not more then 5 symbols
    
    while (*s == _T(' '))
        s++;
    
    PT = 0;

    i = 0;
    while (i < 5 && _istdigit(*s)) {
        PT *= 10;
        PT += (*s - _T('0'));
        s++;
        i++;
    }
    
    while (*s == _T(' '))
        s++;
    
    return (*s == _T('\0'));
}

bool CMsg::ParseINTL(LPCTSTR s) {
    TCHAR szAddrStr[MAX_KLUDGE_SIZE];
    int i;
    
    while (*s == _T(' '))
        s++;

    i = 0;
    while (i < (MAX_KLUDGE_SIZE-1) && *s != _T('\0') && *s != _T(' ')) {
        szAddrStr[i] = *s;
        i++;
        s++;
    }
    if (i == 0)
        return (false);
    if (*s != _T(' '))
        return (false);
    
    szAddrStr[i] = _T('\0');
    if (!ParseFTNAddress( szAddrStr, m_addrINTLTo ))
        return (false);
    
    while (*s == _T(' '))
        s++;

    i = 0;
    while (i < (MAX_KLUDGE_SIZE-1) && *s != _T('\0') && *s != _T(' ')) {
        szAddrStr[i] = *s;
        i++;
        s++;
    }
    if (i == 0)
        return (false);
    szAddrStr[i] = _T('\0');
    
    while (*s == _T(' '))
        s++;
    if (*s != _T('\0'))
        return(false);
    
    return (ParseFTNAddress( szAddrStr, m_addrINTLFrom ));
}

bool CMsg::ParseMsgId(LPCTSTR s) {
    TCHAR str[MAX_KLUDGE_SIZE];
    int         i;
    
    while (*s == _T(' '))
        s++;
    
    if (*s == _T('\0'))
        *m_szMsgIdLine = _T('\0');
    else
        lstrcpy( m_szMsgIdLine, s );
    
    i = 0;
    while (*s != _T(' ') && *s != _T('\0')) {
	str[i] = *s;
	s++;
        i++;
    }
    if (i == 0)
        return (false);
    str[i] = _T('\0');
    return (ParseFTNAddress( str, m_addrMsgIdFrom ));
}

bool CMsg::ParseFTNAddress(LPCTSTR s, SFTNAddress &Address) {
    // parse Zone:Net/Node
    //       Zone:Net/Node.Point
    //       Zone:Net/Node.Point@Domain
    int i; // Not more then 5 symbols on number

    while (*s == _T(' '))
        s++;
    
    // parse zone

    Address.Zone = 0;

    i = 0;
    while (i < 5 && _istdigit(*s)) {
        Address.Zone *= 10;
        Address.Zone += (*s - _T('0'));
        s++;
        i++;
    }
    if (i == 0 || *s != _T(':'))
        return (false);
    
    s++;

    // parse net
    
    Address.Net = 0;

    i = 0;
    while (i < 5 && _istdigit(*s)) {
        Address.Net *= 10;
        Address.Net += (*s - _T('0'));
        s++;
        i++;
    }
    if (i == 0 || *s != _T('/'))
        return (false);
    
    s++;
    
    // parse node

    Address.Node = 0;

    i = 0;
    while (i < 5 && _istdigit(*s)) {
        Address.Node *= 10;
        Address.Node += (*s - _T('0'));
        s++;
        i++;
    }
    if (i == 0)
        return (false);
    
    Address.Point = 0;

    if (*s == _T('.')) {  // parse point
        s++;
        i = 0;
        while (i < 5 && _istdigit(*s)) {
            Address.Point *= 10;
            Address.Point += (*s - _T('0'));
            s++;
            i++;
        }
        if (i == 0)
            return (false);
    }

    Address.Domain[0] = _T('\0');
    if (*s == _T('@')) { // parse domain
        s++;
        i = 0;
        while (i < (MAX_DOMAIN_SIZE-1) && *s != _T(' ') && *s != _T('\0')) {
            Address.Domain[i] = *s;
            s++;
            i++;
        }
        if (i == 0 || (*s != _T(' ') && *s != _T('\0')))
            return (false);
        Address.Domain[i] = _T('\0');
        #ifdef SUBSTITUTE_DOMAIN
        if (lstrcmpi(Address.Domain, _T("Fidonet.org")) == 0)
            lstrcpy( Address.Domain, _T("Fidonet") );
        #endif
    }

    while (*s == _T(' '))
        s++;

    return (*s == _T('\0'));
}

/*
void CMsg::Save() {
    static char TempFileName[MAX_PATH];
    int         SuccessWrite;
    size_t      BytesRead, BytesWritten;
    FILE       *tmp;

    Header.Attrs = Attrs;
    
    strcpy( TempFileName, "TempDir" );
    strcat( TempFileName, "Tracker.tmp" );
    tmp = GetTempFile(TempFileName, "wb" );
    if (tmp) {
        SuccessWrite = SaveMsg( tmp );
        if (SuccessWrite) {
            // compare letters of disks
            if (*MsgFileName == *TempFileName) {
                fclose(f);
		f = NULL;
                remove( MsgFileName );
                rename( TempFileName, MsgFileName );
            }
            else {
                rewind(f);
                tmp = fopen( TempFileName, "rb" );
                BytesRead = fread( GlobalMsgBuf, 1, GlobalMsgBufSize,
                                   tmp );
                while (SuccessWrite && BytesRead > 0) {
                    BytesWritten = fwrite( GlobalMsgBuf, 1, BytesRead, f );
                    SuccessWrite = (BytesWritten == BytesRead);
                    BytesRead = fread( GlobalMsgBuf, 1, GlobalMsgBufSize,
                                       tmp );
                }
                fclose(tmp);
                remove( TempFileName );
            }
        }
    }

    if (f) {
        fclose(f);
	f = NULL;
    }
}

*/

bool CMsg::ParseDOMAIN(LPCTSTR s) {
    TCHAR Domain[MAX_DOMAIN_SIZE];
    TCHAR Str[MAX_KLUDGE_SIZE];
    int i;
    
    while (*s == _T(' '))
        s++;
    
    i = 0;
    while (i < (MAX_DOMAIN_SIZE-1) && *s != _T(' ') && *s != _T('\0')) {
        Domain[i] = *s;
        i++;
        s++;
    }
    if (i == 0)
        return (false);
    
    Domain[i] = _T('\0');
    
    while (*s == _T(' '))
        s++;
    
    i = 0;
    while (i < (MAX_KLUDGE_SIZE-1) && *s != _T(' ') && *s != _T('\0')) {
        Str[i] = *s;
        i++;
        s++;
    }
    Str[i] = _T('\0');
    
    if (!ParseFTNAddress( Str, m_addrDomainKludgeTo ))
        return (false);
    if (*m_addrDomainKludgeTo.Domain != _T('\0'))
        return (false);
    lstrcpy( m_addrDomainKludgeTo.Domain, Domain );
    
    while (*s == _T(' '))
        s++;
    
    i = 0;
    while (i < (MAX_DOMAIN_SIZE-1) && *s != _T(' ') && *s != _T('\0')) {
        Domain[i] = *s;
        i++;
        s++;
    }
    if (i == 0)
        return (false);
    
    Domain[i] = _T('\0');
    
    if (!ParseFTNAddress( s, m_addrDomainKludgeFrom ))
        return (false);
    if (*m_addrDomainKludgeFrom.Domain != _T('\0'))
        return (false);
    lstrcpy( m_addrDomainKludgeFrom.Domain, Domain );

    #ifdef SUBSTITUTE_DOMAIN
    if (lstrcmpi(m_addrDomainKludgeFrom.Domain, _T("Fidonet.org")) == 0)
        lstrcpy( m_addrDomainKludgeFrom.Domain, _T("Fidonet") );
    if (lstrcmpi(m_addrDomainKludgeTo.Domain, _T("Fidonet.org")) == 0)
        lstrcpy( m_addrDomainKludgeTo.Domain, _T("Fidonet") );
    #endif
    return (true);
}

bool CMsg::ParseFlags(LPCTSTR s) {
    TCHAR FlagStr[MAX_FLAG_SIZE];
    int   nParsedFlagsCount;
    int   i;

    nParsedFlagsCount = 0;
    m_vFlags.clear();
    while (*s == _T(' '))
        s++;
    while (*s != _T('\0')) {
        i = 0;
        while (i < (MAX_FLAG_SIZE-1) && *s != _T('\0') && *s != _T(' ')) {
            FlagStr[i] = *s;
            i++;
            s++;
        }
        if (*s != _T('\0') && *s != _T(' '))
            break;
        FlagStr[i] = _T('\0');
        // check known flags
        if (lstrcmp( FlagStr, _T("PVT") ) == 0) {
            m_wAttrs |= ATTR_PRIVATE;
        }
        else if (lstrcmp( FlagStr, _T("HLD") ) == 0) {
            m_wAttrs |= ATTR_HOLD_FOR_PICKUP;
        }
        else if (lstrcmp( FlagStr, _T("CRA") ) == 0) {
            m_wAttrs |= ATTR_CRASH;
        }
        else if (lstrcmp( FlagStr, _T("K/S") ) == 0) {
            m_wAttrs |= ATTR_KILL_SENT;
        }
        else if (lstrcmp( FlagStr, _T("SNT") ) == 0) {
            m_wAttrs |= ATTR_SENT;
        }
        else if (lstrcmp( FlagStr, _T("RCV") ) == 0) {
            m_wAttrs |= ATTR_RECEIVED;
        }
        else if (lstrcmp( FlagStr, _T("FIL") ) == 0) {
            m_wAttrs |= ATTR_FILE_ATTACHED;
        }
        else if (lstrcmp( FlagStr, _T("FRQ") ) == 0) {
            m_wAttrs |= ATTR_FILE_REQ;
        }
        else if (lstrcmp( FlagStr, _T("RRQ") ) == 0) {
            m_wAttrs |= ATTR_RETURN_RECEIPT_REQ;
        }
        else if (lstrcmp( FlagStr, _T("DIR") ) == 0) {
            m_wFlags |= FLAG_DIRECT;
        }
        else if (lstrcmp( FlagStr, _T("IMM") ) == 0) {
            m_wFlags |= FLAG_IMMEDIATE;
        }
        else if (lstrcmp( FlagStr, _T("KFS") ) == 0) {
            m_wFlags |= FLAG_KILL_FILE_SENT;
        }
        else if (lstrcmp( FlagStr, _T("TFS") ) == 0) {
            m_wFlags |= FLAG_TRUNCATE_FILE;
        }
        else if (lstrcmp( FlagStr, _T("LOK") ) == 0) {
            m_wFlags |= FLAG_LOCK;
        }
        else if (lstrcmp( FlagStr, _T("CFM") ) == 0) {
            m_wFlags |= FLAG_CONFIRM_REQ;
        }
        else {
		m_vFlags.push_back( FlagStr );
        }
        
        nParsedFlagsCount++;
        while (*s == _T(' '))
            s++;
    }

    if ((m_wAttrs & ATTR_FILE_ATTACHED) == 0 &&
        ((m_wFlags & (FLAG_KILL_FILE_SENT | FLAG_TRUNCATE_FILE)) != 0))
    {
        m_wFlags &= ~(FLAG_KILL_FILE_SENT | FLAG_TRUNCATE_FILE);
    }
    
    return (nParsedFlagsCount > 0);
}

void CMsg::SetFlag(LPCTSTR s) {
	m_vFlags.push_back(s);
}

bool CMsg::CheckFlag(LPCTSTR s) {
    vector<tstring>::iterator	it = find( m_vFlags.begin(), m_vFlags.end(), tstring(s) );
    return (it != m_vFlags.end());
}

void CMsg::ClearFlag(LPCTSTR s) {
    vector<tstring>::iterator	it = find( m_vFlags.begin(), m_vFlags.end(), tstring(s) );
    if (it != m_vFlags.end())
	    m_vFlags.erase(it);
}

bool CMsg::Delete() {
    CloseFile();
    return (remove(m_szMsgFileName) == 0);
}

inline bool CMsg::FromNet(SFTNAddress &Addr) const {
    return (m_addrFrom.Zone == Addr.Zone && m_addrFrom.Net == Addr.Net);
}

inline bool CMsg::ToNet(SFTNAddress &Addr) const {
    return (m_addrTo.Zone == Addr.Zone && m_addrTo.Net == Addr.Net);
}

inline bool CMsg::FromNode(SFTNAddress &Addr) const {
    return (m_addrFrom.Zone == Addr.Zone && m_addrFrom.Net == Addr.Net
            && m_addrFrom.Node == Addr.Node);
}

inline bool CMsg::ToNode(SFTNAddress &Addr) const {
    return (m_addrTo.Zone == Addr.Zone && m_addrTo.Net == Addr.Net
            && m_addrTo.Node == Addr.Node);
}

inline bool CMsg::FromPoint(SFTNAddress &Addr) const {
    return (m_addrFrom.Zone == Addr.Zone && m_addrFrom.Net == Addr.Net
            && m_addrFrom.Node == Addr.Node && m_addrFrom.Point == Addr.Point);
}

inline bool CMsg::ToPoint(SFTNAddress &Addr) const {
    return (m_addrTo.Zone == Addr.Zone && m_addrTo.Net == Addr.Net
            && m_addrTo.Node == Addr.Node && m_addrTo.Point == Addr.Point);
}

bool CMsg::FromAddr(SFTNAddress &Addr) {
    return (FromPoint(Addr) && (lstrcmpi(m_addrFrom.Domain, Addr.Domain) == 0));
}

bool CMsg::ToAddr(SFTNAddress &Addr) {
    return (ToPoint(Addr) && (lstrcmpi(m_addrTo.Domain, Addr.Domain) == 0));
}

/*

void CMsg::Bounce( uint16 BounceAttrs, uint16 BounceFlags,
                   char *BounceTplFileName,
                   SFTNAddress &BounceAddr )
{
    FILE        *b, *tpl;
    SMsgHeader   BounceHeader;
    static char  Kludge[MAX_KLUDGE_SIZE];
    static char  BounceFileName[MAX_PATH];
    static char  Str[MAX_KLUDGE_SIZE];
    size_t       BytesRead, BytesWritten;
    int          SuccessWrite;
    int          BufPos, CurPos, i;
    int          ReadState, CRWritten;
    const MAX_MACRO_SIZE = 20;
    char         Macro[MAX_MACRO_SIZE];
    enum { TPL_READ, TPL_SKIP_LF, TPL_MACRO };

    // fill bounce header
    memset( &BounceHeader, 0, sizeof(BounceHeader) );
    strcpy( BounceHeader.FromUserName, "Tracker" );
    if (Header.FromUserName)
        strncpy( BounceHeader.ToUserName, Header.FromUserName, 35 );
    else
        *(BounceHeader.ToUserName) = '\0';
    strcpy( BounceHeader.Subject, "Message bounced");
    GetCurrentDateTime( BounceHeader.DateTime );
    BounceHeader.Attrs     = BounceAttrs;
    BounceHeader.OrigZone  = BounceAddr.Zone;
    BounceHeader.OrigNet   = BounceAddr.Net;
    BounceHeader.OrigNode  = BounceAddr.Node;
    BounceHeader.OrigPoint = BounceAddr.Point;
    BounceHeader.DestZone  = From.Zone;
    BounceHeader.DestNet   = From.Net;
    BounceHeader.DestNode  = From.Node;
    BounceHeader.DestPoint = From.Point;
    
    sprintf( BounceFileName, "%s%ld.msg", "MailOut", FreeMsgNumber );
    FreeMsgNumber++;
    b = fopen( BounceFileName, "wb" );
    if (b) {
        // write header
        BytesWritten = fwrite( &BounceHeader, 1, sizeof(BounceHeader), b );
        SuccessWrite = BytesWritten == sizeof(Header);
        // write FMPT kludge, if needed
        if (SuccessWrite) {
            if (BounceAddr.Point != 0) {
                #ifdef SIGNED_ADDR
                sprintf( Kludge, "\1FMPT %hd%c", BounceAddr.Point, 0x0D );
                #else
                sprintf( Kludge, "\1FMPT %hu%c", BounceAddr.Point, 0x0D );
                #endif
                BytesWritten = fwrite( Kludge, 1, strlen(Kludge), b );
                SuccessWrite = BytesWritten == strlen(Kludge);
            }
        }
        // write TOPT kludge, if needed
        if (SuccessWrite) {
            if (From.Point != 0) {
                #ifdef SIGNED_ADDR
                sprintf( Kludge, "\1TOPT %hd%c", From.Point, 0x0D );
                #else
                sprintf( Kludge, "\1TOPT %hu%c", From.Point, 0x0D );
                #endif
                BytesWritten = fwrite( Kludge, 1, strlen(Kludge), b );
                SuccessWrite = BytesWritten == strlen(Kludge);
            }
        }
        // write INTL kludge
        if (SuccessWrite) {
            #ifdef SIGNED_ADDR
            sprintf( Kludge, "\1INTL %hd:%hd/%hd %hd:%hd/%hd%c",
                     From.Zone, From.Net, From.Node,
                     BounceAddr.Zone, BounceAddr.Net, BounceAddr.Node,
                     0x0D );
            #else
            sprintf( Kludge, "\1INTL %hu:%hu/%hu %hu:%hu/%hu%c",
                     From.Zone, From.Net, From.Node,
                     BounceAddr.Zone, BounceAddr.Net, BounceAddr.Node,
                     0x0D );
            #endif
            BytesWritten = fwrite( Kludge, 1, strlen(Kludge), b );
            SuccessWrite = BytesWritten == strlen(Kludge);
        }
        // write FLAGS kludge
        if (SuccessWrite && BounceFlags != 0) {
            strcpy( Kludge, "\1FLAGS" );
            if (BounceFlags & FLAG_DIRECT) {
                strcat( Kludge, " " );
                strcat( Kludge, "DIR" );
            }
            if (BounceFlags & FLAG_IMMEDIATE) {
                strcat( Kludge, " " );
                strcat( Kludge, "IMM" );
            }
            if (BounceFlags & FLAG_KILL_FILE_SENT) {
                strcat( Kludge, " " );
                strcat( Kludge, "KFS" );
            }
            if (BounceFlags & FLAG_TRUNCATE_FILE) {
                strcat( Kludge, " " );
                strcat( Kludge, "TFS" );
            }
            if (BounceFlags & FLAG_LOCK) {
                strcat( Kludge, " " );
                strcat( Kludge, "LOK" );
            }
            if (BounceFlags & FLAG_CONFIRM_REQ) {
                strcat( Kludge, " " );
                strcat( Kludge, "CFM" );
            }
            // add 0x0D
            Kludge[strlen(Kludge)+1] = '\0';
            Kludge[strlen(Kludge)] = 0x0D;
            BytesWritten = fwrite( Kludge, 1, strlen(Kludge), b );
            SuccessWrite = BytesWritten == strlen(Kludge);
        }
        // write MSGID: kludge
        if (SuccessWrite) {
            if (BounceAddr.Point != 0) {
                #ifdef SIGNED_ADDR
                sprintf( Kludge, "\01MSGID: %hd:%hd/%hd.%hd@%s %0lx%c",
                         BounceAddr.Zone, BounceAddr.Net, BounceAddr.Node,
                         BounceAddr.Point, BounceAddr.Domain,
                         MsgIdHandler.Get(), 0x0D
                       );
                #else
                sprintf( Kludge, "\01MSGID: %hu:%hu/%hu.%hu@%s %0lx%c",
                         BounceAddr.Zone, BounceAddr.Net, BounceAddr.Node,
                         BounceAddr.Point, BounceAddr.Domain,
                         MsgIdHandler.Get(), 0x0D
                       );
                #endif
            }
            else {
                #ifdef SIGNED_ADDR
                sprintf( Kludge, "\01MSGID: %hd:%hd/%hd@%s %0lx%c",
                         BounceAddr.Zone, BounceAddr.Net, BounceAddr.Node,
                         BounceAddr.Domain, MsgIdHandler.Get(), 0x0D
                       );
                #else
                sprintf( Kludge, "\01MSGID: %hu:%hu/%hu@%s %0lx%c",
                         BounceAddr.Zone, BounceAddr.Net, BounceAddr.Node,
                         BounceAddr.Domain, MsgIdHandler.Get(), 0x0D
                       );
                #endif
            }
            BytesWritten = fwrite( Kludge, 1, strlen(Kludge), b );
            SuccessWrite = BytesWritten == strlen(Kludge);
        }
        // write REPLY: kludge
        if (SuccessWrite && *MsgIdLine) {
            strcpy( Kludge, "\01REPLY: " );
            strcat( Kludge, MsgIdLine );
            Kludge[strlen(Kludge)+1] = '\0';
            Kludge[strlen(Kludge)] = 0x0D;
            BytesWritten = fwrite( Kludge, 1, strlen(Kludge), b );
            SuccessWrite = BytesWritten == strlen(Kludge);
        }
        // write DOMAIN kludge
        if (SuccessWrite && stricmp(BounceAddr.Domain, From.Domain) != 0) {
            #ifdef SIGNED_ADDR
            sprintf( Kludge,
                     "\1DOMAIN %s %hd:%hd/%hd.%hd %s %hd:%hd/%hd.%hd%c",
                     From.Domain, From.Zone, From.Net, From.Node, From.Point,
                     BounceAddr.Domain, BounceAddr.Zone, BounceAddr.Net,
                     BounceAddr.Node, BounceAddr.Point, 0x0D );
            #else
            sprintf( Kludge,
                     "\1DOMAIN %s %hu:%hu/%hu.%hu %s %hu:%hu/%hu.%hu%c",
                     From.Domain, From.Zone, From.Net, From.Node, From.Point,
                     BounceAddr.Domain, BounceAddr.Zone, BounceAddr.Net,
                     BounceAddr.Node, BounceAddr.Point, 0x0D );
            #endif
            BytesWritten = fwrite( Kludge, 1, strlen(Kludge), b );
            SuccessWrite = BytesWritten == strlen(Kludge);
        }
        CRWritten = 1;
        if (SuccessWrite && BounceTplFileName != NULL) {
            tpl = fopen( BounceTplFileName, "rb" );
            if (tpl) {
                BytesRead = fread( Kludge, 1, MAX_KLUDGE_SIZE, tpl );
                BufPos = 0;
                ReadState = TPL_READ;
                while (SuccessWrite && BytesRead > 0) {
                    switch (ReadState) {
                    case TPL_READ:
                        CurPos = BufPos;
                        while (BufPos < BytesRead && Kludge[BufPos] != '@'
                              && Kludge[BufPos] != 0x0D)
                            BufPos++;
                        if (BufPos >= BytesRead) {
                            if (BufPos > CurPos) {
                                BytesWritten = fwrite( Kludge + CurPos, 1,
                                                       BufPos-CurPos, b );
                                SuccessWrite = (BytesWritten == BufPos-CurPos);
                                CRWritten = 0;
                            }
                            BytesRead = fread( Kludge, 1, MAX_KLUDGE_SIZE,
                                               tpl );
                            BufPos = 0;
                            break;
                        }
                        if (Kludge[BufPos] == '@') {
                            if (BufPos > CurPos) {
                                BytesWritten = fwrite( Kludge + CurPos, 1,
                                                       BufPos-CurPos, b );
                                SuccessWrite = (BytesWritten == BufPos-CurPos);
                                CRWritten = 0;
                            }
                            ReadState = TPL_MACRO;
                            BufPos++;
                            i = 0;
                            *Macro = '\0';
                            break;
                        }
                        // 0x0D
                        BufPos++;
                        BytesWritten = fwrite( Kludge + CurPos, 1,
                                               BufPos-CurPos, b );
                        SuccessWrite = (BytesWritten == BufPos-CurPos);
                        CRWritten = 1;
                        ReadState = TPL_SKIP_LF;
                        break;
                    case TPL_MACRO:
                        while (BufPos < BytesRead && i < MAX_MACRO_SIZE-1
                               && ((Kludge[BufPos] >= 'a' &&
                                    Kludge[BufPos] <= 'z') ||
                                   (Kludge[BufPos] >= 'A' &&
                                    Kludge[BufPos] <= 'Z')))
                        {
                            Macro[i] = Kludge[BufPos];
                            BufPos++;
                            i++;
                        }
                        Macro[i] = '\0';
                        if (BufPos >= BytesRead) {
                            BytesRead = fread( Kludge, 1, MAX_KLUDGE_SIZE,
                                               tpl );
                            BufPos = 0;
                            break;
                        }
                        if (*Macro == '\0') {
                            BytesWritten = fwrite( "@", 1,
                                                   1, b );
                            SuccessWrite = (BytesWritten == 1);
                            if (Kludge[BufPos] == '@')
                                BufPos++;
                            CRWritten = 0;
                        }
                        else if (stricmp( Macro, "FName" ) == 0) {
                            BytesWritten = fwrite( Header.FromUserName, 1,
                                                   strlen(Header.FromUserName),
                                                   b );
                            SuccessWrite = (BytesWritten ==
                                           strlen(Header.FromUserName));
                            CRWritten = 0;
                        }
                        else if (stricmp( Macro, "TName" ) == 0) {
                            BytesWritten = fwrite( Header.ToUserName, 1,
                                                   strlen(Header.ToUserName),
                                                   b );
                            SuccessWrite = (BytesWritten ==
                                           strlen(Header.ToUserName));
                            CRWritten = 0;
                        }
                        else if (stricmp( Macro, "FAddr" ) == 0) {
                            #ifdef SIGNED_ADDR
                            sprintf( Str, "%hd:%hd/%hd.%hd",
                                     From.Zone, From.Net, From.Node,
                                     From.Point );
                            #else
                            sprintf( Str, "%hu:%hu/%hu.%hu",
                                     From.Zone, From.Net, From.Node,
                                     From.Point );
                            #endif
                            BytesWritten = fwrite( Str, 1, strlen(Str), b );
                            SuccessWrite = (BytesWritten == strlen(Str));
                            CRWritten = 0;
                        }
                        else if (stricmp( Macro, "TAddr" ) == 0) {
                            #ifdef SIGNED_ADDR
                            sprintf( Str, "%hd:%hd/%hd.%hd",
                                     To.Zone, To.Net, To.Node, To.Point );
                            #else
                            sprintf( Str, "%hu:%hu/%hu.%hu",
                                     To.Zone, To.Net, To.Node, To.Point );
                            #endif
                            BytesWritten = fwrite( Str, 1, strlen(Str), b );
                            SuccessWrite = (BytesWritten == strlen(Str));
                        }
                        else if (stricmp( Macro, "FDomain" ) == 0) {
                            BytesWritten = fwrite( From.Domain, 1,
                                                   strlen(From.Domain),
                                                   b );
                            SuccessWrite = (BytesWritten ==
                                           strlen(From.Domain));
                            CRWritten = 0;
                        }
                        else if (stricmp( Macro, "TDomain" ) == 0) {
                            BytesWritten = fwrite( To.Domain, 1,
                                                   strlen(To.Domain),
                                                   b );
                            SuccessWrite = (BytesWritten ==
                                           strlen(To.Domain));
                            CRWritten = 0;
                        }
                        else if (stricmp( Macro, "Subject" ) == 0) {
                            BytesWritten = fwrite( Header.Subject, 1,
                                                   strlen(Header.Subject),
                                                   b );
                            SuccessWrite = (BytesWritten ==
                                           strlen(Header.Subject));
                            CRWritten = 0;
                        }
                        else if (stricmp( Macro, "SName" ) == 0) {
                            BytesWritten = fwrite( "SysOpName", 1,
                                                   strlen("SysOpName"),
                                                   b );
                            SuccessWrite = (BytesWritten ==
                                           strlen("SysOp"));
                            CRWritten = 0;
                        }
                        else if (stricmp( Macro, "SAddr" ) == 0) {
                            #ifdef SIGNED_ADDR
                            sprintf( Str, "%hd:%hd/%hd.%hd",
                                     BounceAddr.Zone, BounceAddr.Net,
                                     BounceAddr.Node, BounceAddr.Point );
                            #else
                            sprintf( Str, "%hu:%hu/%hu.%hu",
                                     BounceAddr.Zone, BounceAddr.Net,
                                     BounceAddr.Node, BounceAddr.Point );
                            #endif
                            BytesWritten = fwrite( Str, 1, strlen(Str), b );
                            SuccessWrite = (BytesWritten == strlen(Str));
                            CRWritten = 0;
                        }
                        else if (stricmp( Macro, "SDomain" ) == 0) {
                            BytesWritten = fwrite( BounceAddr.Domain, 1,
                                                   strlen(BounceAddr.Domain),
                                                   b );
                            SuccessWrite = (BytesWritten ==
                                           strlen(BounceAddr.Domain));
                            CRWritten = 0;
                        }
                        else if (stricmp( Macro, "DateTime" ) == 0) {
                            BytesWritten = fwrite( Header.DateTime, 1,
                                                   strlen(Header.DateTime),
                                                   b );
                            SuccessWrite = (BytesWritten ==
                                           strlen(Header.DateTime));
                            CRWritten = 0;
                        }
                        ReadState = TPL_READ;
                        break;
                    case TPL_SKIP_LF:
                        if (BufPos >= BytesRead) {
                            BytesRead = fread( Kludge, 1, MAX_KLUDGE_SIZE,
                                               tpl );
                            BufPos = 0;
                            break;
                        }
                        if (Kludge[BufPos] == 0x0A)
                            BufPos++;
                        ReadState = TPL_READ;
                        break;
                    }
                }
                if (ReadState == TPL_MACRO) {
                    if (*Macro == '\0') {
                        BytesWritten = fwrite( "@", 1,
                                               1, b );
                        SuccessWrite = (BytesWritten == 1);
                        CRWritten = 0;
                    }
                    else if (stricmp( Macro, "FName" ) == 0) {
                        BytesWritten = fwrite( Header.FromUserName, 1,
                                               strlen(Header.FromUserName),
                                               b );
                        SuccessWrite = (BytesWritten ==
                                       strlen(Header.FromUserName));
                        CRWritten = 0;
                    }
                    else if (stricmp( Macro, "TName" ) == 0) {
                        BytesWritten = fwrite( Header.ToUserName, 1,
                                               strlen(Header.ToUserName),
                                               b );
                        SuccessWrite = (BytesWritten ==
                                       strlen(Header.ToUserName));
                        CRWritten = 0;
                    }
                    else if (stricmp( Macro, "FAddr" ) == 0) {
                        #ifdef SIGNED_ADDR
                        sprintf( Str, "%hd:%hd/%hd.%hd",
                                 From.Zone, From.Net, From.Node,
                                 From.Point );
                        #else
                        sprintf( Str, "%hu:%hu/%hu.%hu",
                                 From.Zone, From.Net, From.Node,
                                 From.Point );
                        #endif
                        BytesWritten = fwrite( Str, 1, strlen(Str), b );
                        SuccessWrite = (BytesWritten == strlen(Str));
                        CRWritten = 0;
                    }
                    else if (stricmp( Macro, "TAddr" ) == 0) {
                        #ifdef SIGNED_ADDR
                        sprintf( Str, "%hd:%hd/%hd.%hd",
                                 To.Zone, To.Net, To.Node, To.Point );
                        #else
                        sprintf( Str, "%hu:%hu/%hu.%hu",
                                 To.Zone, To.Net, To.Node, To.Point );
                        #endif
                        BytesWritten = fwrite( Str, 1, strlen(Str), b );
                        SuccessWrite = (BytesWritten == strlen(Str));
                    }
                    else if (stricmp( Macro, "FDomain" ) == 0) {
                        BytesWritten = fwrite( From.Domain, 1,
                                               strlen(From.Domain),
                                               b );
                        SuccessWrite = (BytesWritten ==
                                       strlen(From.Domain));
                        CRWritten = 0;
                    }
                    else if (stricmp( Macro, "TDomain" ) == 0) {
                        BytesWritten = fwrite( To.Domain, 1,
                                               strlen(To.Domain),
                                               b );
                        SuccessWrite = (BytesWritten ==
                                       strlen(To.Domain));
                        CRWritten = 0;
                    }
                    else if (stricmp( Macro, "Subject" ) == 0) {
                        BytesWritten = fwrite( Header.Subject, 1,
                                               strlen(Header.Subject),
                                               b );
                        SuccessWrite = (BytesWritten ==
                                       strlen(Header.Subject));
                        CRWritten = 0;
                    }
                    else if (stricmp( Macro, "SName" ) == 0) {
                        BytesWritten = fwrite( "SysOpName", 1,
                                               strlen( "SysopName" ),
                                               b );
                        SuccessWrite = (BytesWritten ==
                                       strlen("SysOpName"));
                        CRWritten = 0;
                    }
                    else if (stricmp( Macro, "SAddr" ) == 0) {
                        #ifdef SIGNED_ADDR
                        sprintf( Str, "%hd:%hd/%hd.%hd",
                                 BounceAddr.Zone, BounceAddr.Net,
                                 BounceAddr.Node, BounceAddr.Point );
                        #else
                        sprintf( Str, "%hu:%hu/%hu.%hu",
                                 BounceAddr.Zone, BounceAddr.Net,
                                 BounceAddr.Node, BounceAddr.Point );
                        #endif
                        BytesWritten = fwrite( Str, 1, strlen(Str), b );
                        SuccessWrite = (BytesWritten == strlen(Str));
                        CRWritten = 0;
                    }
                    else if (stricmp( Macro, "SDomain" ) == 0) {
                        BytesWritten = fwrite( BounceAddr.Domain, 1,
                                               strlen(BounceAddr.Domain),
                                               b );
                        SuccessWrite = (BytesWritten ==
                                       strlen(BounceAddr.Domain));
                        CRWritten = 0;
                    }
                    else if (stricmp( Macro, "DateTime" ) == 0) {
                        BytesWritten = fwrite( Header.DateTime, 1,
                                               strlen(Header.DateTime),
                                               b );
                        SuccessWrite = (BytesWritten ==
                                       strlen(Header.DateTime));
                        CRWritten = 0;
                    }
                }
                fclose(tpl);
            }
        }
        fclose(b);
    }

}

int CMsg::SaveMsg(FILE *tmp) {
    size_t      BytesRead, BytesWritten;
    static char Kludge[MAX_KLUDGE_SIZE];
    int         SuccessWrite;
    int         SaveCondition;
    int         WriteKludge;
    int         ZeroWritten;
    int         EOLRead, EOLWritten;
    int         BufPos, CurPos;
    char       *buf, *kl;
    int         i;
    
    rewind(f);
    fseek( f, sizeof(Header), SEEK_SET );
    // write header
    BytesWritten = fwrite( &Header, 1, sizeof(Header), tmp );
    SuccessWrite = BytesWritten == sizeof(Header);
    // write AREA , if needed
    if (SuccessWrite && *Area) {
        sprintf( Kludge, "AREA:%s%c", Area, 0x0D );
        BytesWritten = fwrite( Kludge, 1, strlen(Kludge), tmp );
        SuccessWrite = BytesWritten == strlen(Kludge);
    }
    // write FMPT kludge, if needed
    if (SuccessWrite) {
        if (From.Point != 0) {
            #ifdef SIGNED_ADDR
            sprintf( Kludge, "\1FMPT %hd%c", From.Point, 0x0D );
            #else
            sprintf( Kludge, "\1FMPT %hu%c", From.Point, 0x0D );
            #endif
            BytesWritten = fwrite( Kludge, 1, strlen(Kludge), tmp );
            SuccessWrite = BytesWritten == strlen(Kludge);
        }
    }
    // write TOPT kludge, if needed
    if (SuccessWrite) {
        if (To.Point != 0) {
            #ifdef SIGNED_ADDR
            sprintf( Kludge, "\1TOPT %hd%c", To.Point, 0x0D );
            #else
            sprintf( Kludge, "\1TOPT %hu%c", To.Point, 0x0D );
            #endif
            BytesWritten = fwrite( Kludge, 1, strlen(Kludge), tmp );
            SuccessWrite = BytesWritten == strlen(Kludge);
        }
    }
    // write INTL kludge
    if (SuccessWrite) {
        #ifdef SIGNED_ADDR
        sprintf( Kludge, "\1INTL %hd:%hd/%hd %hd:%hd/%hd%c",
                 To.Zone, To.Net, To.Node, From.Zone, From.Net, From.Node,
                 0x0D );
        #else
        sprintf( Kludge, "\1INTL %hu:%hu/%hu %hu:%hu/%hu%c",
                 To.Zone, To.Net, To.Node, From.Zone, From.Net, From.Node,
                 0x0D );
        #endif
        BytesWritten = fwrite( Kludge, 1, strlen(Kludge), tmp );
        SuccessWrite = BytesWritten == strlen(Kludge);
    }
    // write FLAGS kludge
    if (SuccessWrite && (Flags != 0 || *FlagsKludge != '\0')) {
        strcpy( Kludge, "\1FLAGS" );
        if (Flags & FLAG_DIRECT) {
            strcat( Kludge, " " );
            strcat( Kludge, "DIR" );
        }
        if (Flags & FLAG_IMMEDIATE) {
            strcat( Kludge, " " );
            strcat( Kludge, "IMM" );
        }
        if (Flags & FLAG_KILL_FILE_SENT) {
            strcat( Kludge, " " );
            strcat( Kludge, "KFS" );
        }
        if (Flags & FLAG_TRUNCATE_FILE) {
            strcat( Kludge, " " );
            strcat( Kludge, "TFS" );
        }
        if (Flags & FLAG_LOCK) {
            strcat( Kludge, " " );
            strcat( Kludge, "LOK" );
        }
        if (Flags & FLAG_CONFIRM_REQ) {
            strcat( Kludge, " " );
            strcat( Kludge, "CFM" );
        }
        if (*FlagsKludge != '\0')
            strcat( Kludge, FlagsKludge );
        // add 0x0D
        Kludge[strlen(Kludge)+1] = '\0';
        Kludge[strlen(Kludge)] = 0x0D;
        BytesWritten = fwrite( Kludge, 1, strlen(Kludge), tmp );
        SuccessWrite = BytesWritten == strlen(Kludge);
    }
    // write DOMAIN kludge
    if (SuccessWrite && stricmp(From.Domain, To.Domain) != 0) {
        #ifdef SIGNED_ADDR
        sprintf( Kludge,
                 "\1DOMAIN %s %hd:%hd/%hd.%hd %s %hd:%hd/%hd.%hd%c",
                 To.Domain, To.Zone, To.Net, To.Node, To.Point,
                 From.Domain, From.Zone, From.Net, From.Node, From.Point,
                 0x0D );
        #else
        sprintf( Kludge,
                 "\1DOMAIN %s %hu:%hu/%hu.%hu %s %hu:%hu/%hu.%hu%c",
                 To.Domain, To.Zone, To.Net, To.Node, To.Point,
                 From.Domain, From.Zone, From.Net, From.Node, From.Point,
                 0x0D );
        #endif
        BytesWritten = fwrite( Kludge, 1, strlen(Kludge), tmp );
        SuccessWrite = BytesWritten == strlen(Kludge);
    }
    // write from msg to tmp
    BytesRead = fread( GlobalMsgBuf, 1, GlobalMsgBufSize, f );
    BufPos = 0;
    Kludge[0] = 0x01;
    SaveCondition = SAVE_READ;
    ZeroWritten = 0;
    EOLRead = 0;
    EOLWritten = 1;
    while (SuccessWrite && BytesRead > 0) {
        switch (SaveCondition) {
        case SAVE_READ:
            CurPos = BufPos;
            buf    = GlobalMsgBuf + CurPos;
            // while not kludge
            while (BufPos < BytesRead && *buf != 0x01) {
                if (*buf != '\0')
                    EOLRead = 0;
                // while not end of line
                while (BufPos < BytesRead && *buf != 0x0D) {
                    BufPos++;
                    buf++;
                }
                // check CRLF sequence
                if (BufPos < BytesRead) { // 0x0D
                    EOLRead = 1;
                    BufPos++;
                    buf++;
                    if (BufPos < BytesRead && *buf == 0x0A) {
                        BufPos++;
                        buf++;
                    }
                }
            }
            // write data, if more than zero bytes
            if (BufPos > CurPos) {
                BytesWritten = fwrite( GlobalMsgBuf + CurPos, 1,
                                       BufPos-CurPos, tmp );
                ZeroWritten = (GlobalMsgBuf[BufPos-1] == '\0');
                EOLWritten = EOLRead;
                SuccessWrite = (BytesWritten == BufPos-CurPos);
            }
            if (BufPos < BytesRead) { // 0x01
                i = 1;
                BufPos++;
                SaveCondition = SAVE_MIDDLE_OF_KLUDGE;
            }
            else {
                BytesRead = fread( GlobalMsgBuf, 1, GlobalMsgBufSize,
                                   f );
                BufPos = 0;
            }
            break;
        case SAVE_MIDDLE_OF_KLUDGE:
            buf = GlobalMsgBuf + BufPos;
            while (BufPos < BytesRead && i < (MAX_KLUDGE_SIZE-1) &&
                   *buf != 0x0D)
            {
                Kludge[i] = *buf;
                i++;
                buf++;
                BufPos++;
            }
            if (BufPos < BytesRead) { // Kludge had been read
                Kludge[i] = '\0';
                // check kludge
                WriteKludge = 1; // unknown writable kludge
                kl = Kludge+1;
                if (strncmp( kl, "FMPT ", 5) == 0) {
                    WriteKludge = 0;
                }
                else if (strncmp( kl, "TOPT ", 5) == 0) {
                    WriteKludge = 0;
                }
                else if (strncmp( kl, "INTL ", 5) == 0) {
                    WriteKludge = 0;
                }
                else if (strncmp( kl, "FLAGS ", 6) == 0) {
                    WriteKludge = 0;
                }
                else if (strncmp( kl, "DOMAIN ", 7) == 0) {
                    WriteKludge = 0;
                }
                if (WriteKludge) {
                    BytesWritten = fwrite( Kludge, 1, strlen(Kludge),
                                           tmp );
                    SuccessWrite = (BytesWritten == strlen(Kludge));
                    ZeroWritten = 0;
                    EOLWritten = 0;
                    SaveCondition = SAVE_WRITE_LINE;
                }
                else
                    SaveCondition = SAVE_SKIP_LINE;
            }
            else {
                BytesRead = fread( GlobalMsgBuf, 1, GlobalMsgBufSize,
                                   f );
                BufPos = 0;
            }
            break;
        case SAVE_WRITE_LINE:
            CurPos = BufPos;
            buf = GlobalMsgBuf + CurPos;
            // while not end of line
            EOLRead = 0;
            while (BufPos < BytesRead && *buf != 0x0D) {
                BufPos++;
                buf++;
            }
            // check CRLF sequence
            if (BufPos < BytesRead) { // 0x0D
                EOLRead = 1;
                BufPos++;
                buf++;
                if (BufPos < BytesRead && *buf == 0x0A) {
                    BufPos++;
                    buf++;
                }
            }
            if (BufPos > CurPos) {
                BytesWritten = fwrite( GlobalMsgBuf + CurPos, 1 ,
                                       BufPos - CurPos, tmp );
                ZeroWritten = (GlobalMsgBuf[BufPos-1] == '\0');
                EOLWritten = EOLRead;
                SuccessWrite = (BytesWritten == BufPos-CurPos);
            }
            SaveCondition = SAVE_READ;
            break;
        case SAVE_SKIP_LINE:
            buf = GlobalMsgBuf + BufPos;
            // while not end of line
            while (BufPos < BytesRead && *buf != 0x0D) {
                BufPos++;
                buf++;
            }
            // check CRLF sequence
            if (BufPos < BytesRead) { // 0x0D
                BufPos++;
                buf++;
                if (BufPos < BytesRead && *buf == 0x0A) {
                    BufPos++;
                    buf++;
                }
            }
            SaveCondition = SAVE_READ;
            break;
        }
    }

    if (SuccessWrite && SaveCondition == SAVE_MIDDLE_OF_KLUDGE) {
        Kludge[i] = '\0';
        // check kludge
        WriteKludge = 1; // unknown writable kludge
        kl = Kludge+1;
        if (strncmp( kl, "FMPT ", 5) == 0) {
            WriteKludge = 0;
        }
        else if (strncmp( kl, "TOPT ", 5) == 0) {
            WriteKludge = 0;
        }
        else if (strncmp( kl, "INTL ", 5) == 0) {
            WriteKludge = 0;
        }
        else if (strncmp( kl, "FLAGS ", 6) == 0) {
            WriteKludge = 0;
        }
        else if (strncmp( kl, "DOMAIN ", 6) == 0) {
            WriteKludge = 0;
        }
        if (WriteKludge) {
            BytesWritten = fwrite( Kludge, 1, strlen(Kludge),
                                   tmp );
            ZeroWritten = 0;
            EOLWritten = 0;
            SuccessWrite = (BytesWritten == strlen(Kludge));
        }
    }

    if (SuccessWrite && !ZeroWritten) {
        BytesWritten = fwrite( "", 1, 1, tmp );
        SuccessWrite = (BytesWritten == 1);
    }
    
    fclose(tmp);

    return (SuccessWrite);
}


bool CMsg::Move(LPCTSTRr szDir, long &lFreeNumber) {
	TCHAR	szTempFileName[MAX_PATH];
	bool        fSuccessWrite;
	DWORD	dwBytesRead, dwBytesWritten;
	HANDLE	hTempFile;

	m_Header.Attrs = m_wAttrs;

	// check, if moving in message directory
	if (lstrcmpi( szDir, m_szMsgFileDir ) == 0) {
		lstrcpy( szTempFileName, _T("AdrenalinMsg.tmp") );
		hTempFile = GetTempFile( szTempFileName, GENERIC_READ | GENERIC_WRITE );
		if (hTempFile != INVALID_FILE_HANDLE) {
			fSuccessWrite = SaveMsg( hTempFile );
			if (fSuccessWrite) {
				// compare letters of disks
				if (*m_szMsgFileName == *szTempFileName) {
					CloseFile();
					remove( m_szMsgFileName );
					rename( szTempFileName, m_szMsgFileName );
				}
				else {
					if (SetFilePointer( m_hFile, 0, NULL, FILE_BEGIN ) != 0xFFFFFFFF) {
						tmp = fopen( TempFileName, "rb" );
						BytesRead = fread( GlobalMsgBuf, 1, GlobalMsgBufSize,
						       tmp );
						while (SuccessWrite && BytesRead > 0) {
						BytesWritten = fwrite( GlobalMsgBuf, 1, BytesRead, f );
						SuccessWrite = (BytesWritten == BytesRead);
						BytesRead = fread( GlobalMsgBuf, 1, GlobalMsgBufSize,
							   tmp );
						}
						fclose(tmp);
						remove( TempFileName );
					}
				}
            }
        }
    }
    else {
        sprintf( TempFileName, "%s%ld.msg", Dir, FreeNumber );
        tmp = fopen( TempFileName, "wb" );
        SuccessWrite = 0;
        if (tmp) {
            SuccessWrite = SaveMsg( tmp );
            if (SuccessWrite) {
                fclose(f);
                f = NULL;
                remove( MsgFileName );
                FreeNumber++;
            }
        }
    }

    
    if (f) {
        fclose(f);
	f = NULL;
    }

    return (SuccessWrite && tmp != NULL);
}

int CMsg::FromUs() {
    if (FromPoint(GlobalVars.MainAddr))
        return (1);
    return (0);
}

int CMsg::ToUs() {
    if (ToPoint(GlobalVars.MainAddr))
        return (1);
    return (0);
}
*/

int GetNumberOfLines(LPCTSTR s) {
	int	nNumber = 0;
	while ((*s) != TEXT('\0')) {
		if ((*s) == TEXT('\015'))
			nNumber++;
		s++;
	}
	return (nNumber);
}

void CMsg::Reply( uint16 wReplyAttrs, uint16 wReplyFlags, LPCTSTR szSubject,
                  const vector<tstring> &vBodyLines )
{
	CFile		replyFile;
	SMsgHeader	replyHeader;
	TCHAR		szKludge[MAX_KLUDGE_SIZE];
	char		szOemKludge[MAX_KLUDGE_SIZE];
	char		szLine[512];
	TCHAR		szReplyFileName[MAX_PATH];
	bool		fSuccessWrite;

	char*		szOemSubject;
	int		nSubjectLen;

	char*		szSplittedMsgSubj;
	char*		szSplittedMsgHead;
	char*		szSplittedMsgTail;

	vector<int>	viLineLengths;
	vector<int>	viLinesPerLine;
	int		nBodySize;
	int		nNumberOfLines;
	int		nNumberOfMessages;
	int		nMessage;
	int		nLine;
	int		nKBytesLimit;
	int		nLinesLimit;

	vector<tstring>::const_iterator	it;


	// prepare subject
	nSubjectLen  = lstrlen(szSubject);
	szOemSubject = new char[nSubjectLen + 128];	// use margin
	CharToOem( szSubject, szOemSubject );

	// prepare templates for splitted message
	szSplittedMsgSubj = new char[lstrlen(pAdrenalin->m_language[LNG_SPLITTED_MSG_SUBJ]) + 1];
	CharToOem( pAdrenalin->m_language[LNG_SPLITTED_MSG_SUBJ], szSplittedMsgSubj );
	szSplittedMsgHead = new char[lstrlen(pAdrenalin->m_language[LNG_SPLITTED_MSG_HEAD]) + 1];
	CharToOem( pAdrenalin->m_language[LNG_SPLITTED_MSG_HEAD], szSplittedMsgHead );
	szSplittedMsgTail = new char[lstrlen(pAdrenalin->m_language[LNG_SPLITTED_MSG_TAIL]) + 1];
	CharToOem( pAdrenalin->m_language[LNG_SPLITTED_MSG_TAIL], szSplittedMsgTail );

	// gather data about message body
	nNumberOfMessages = 1;
	nKBytesLimit = g_vars.m_nMessageKBytesLimit;
	nLinesLimit  = g_vars.m_nMessageLinesLimit;
	if ((nKBytesLimit != 0) || (nLinesLimit != 0)) {
		// process first line	
		it = vBodyLines.begin();
		if (it != vBodyLines.end()) {
			int	nLen = (*it).length() + 1;	// 1 for CR
			viLineLengths.push_back(nLen);
			int	nLines = GetNumberOfLines((*it).c_str()) + 1;
			viLinesPerLine.push_back( nLines );
			nBodySize      = nLen;
			nNumberOfLines = nLines;
			it++;
			for (; it != vBodyLines.end(); it++) {
				int	nLen = (*it).length() + 1;	// 1 for CR
				viLineLengths.push_back(nLen);
				int	nLines = GetNumberOfLines((*it).c_str()) + 1;
				viLinesPerLine.push_back( nLines );
				nBodySize      += nLen;
				nNumberOfLines += nLines;
				if (nKBytesLimit > 0 && nBodySize > nKBytesLimit) {
					nNumberOfMessages++;
					nBodySize      = nLen;
					nNumberOfLines = nLines;
				}
				else
				if (nLinesLimit > 0 && nNumberOfLines > nLinesLimit) {
					nNumberOfMessages++;
					nBodySize      = nLen;
					nNumberOfLines = nLines;
				}
			}
		}
	}

	// fill reply header

	::FillMemory( &replyHeader, sizeof(replyHeader), 0 );
	strcpy( replyHeader.m_szFromUserName, m_Header.m_szToUserName   );
	strcpy( replyHeader.m_szToUserName,   m_Header.m_szFromUserName );
	replyHeader.m_wAttrs     = wReplyAttrs;
	replyHeader.m_wOrigZone  = m_addrTo.Zone;
	replyHeader.m_wOrigNet   = m_addrTo.Net;
	replyHeader.m_wOrigNode  = m_addrTo.Node;
	replyHeader.m_wOrigPoint = m_addrTo.Point;
	replyHeader.m_wDestZone  = m_addrFrom.Zone;
	replyHeader.m_wDestNet   = m_addrFrom.Net;
	replyHeader.m_wDestNode  = m_addrFrom.Node;
	replyHeader.m_wDestPoint = m_addrFrom.Point;

	nMessage = 1;
	nLine    = 0;
	it = vBodyLines.begin();
	do {
		// open file
		_stprintf( szReplyFileName, _T("%s%ld.msg"), g_vars.m_szNetmailPath,
			m_lFreeMsgNumber );
		m_lFreeMsgNumber++;
		// keep last file name for outers
		lstrcpy( m_szLastReplyFileName, szReplyFileName );

		if (replyFile.Open( szReplyFileName, GENERIC_WRITE, CREATE_NEW, FILE_ATTRIBUTE_NORMAL )) {
			// write header
			// 1) set subject
			if (nNumberOfMessages > 1) {
				sprintf( szOemSubject + nSubjectLen, szSplittedMsgSubj, nMessage, nNumberOfMessages );
			}
			StrNCpy( replyHeader.m_szSubject, szOemSubject, MSG_SUBJECT_LENGTH-1 );
			// 2) set date and time
			GetCurrentDateTime( replyHeader.m_szDateTime );
			fSuccessWrite = replyFile.Write( &replyHeader, sizeof(replyHeader) );
			// write FMPT kludge, if needed
			if (fSuccessWrite) {
				if (m_addrTo.Point != 0) {
					sprintf( szOemKludge, "\1FMPT %hu%c", m_addrTo.Point, 0x0D );
					fSuccessWrite = replyFile.WriteOemString( szOemKludge );
				}
			}
			// write TOPT kludge, if needed
			if (fSuccessWrite) {
				if (m_addrFrom.Point != 0) {
					sprintf( szOemKludge, "\1TOPT %hu%c", m_addrFrom.Point, 0x0D );
					fSuccessWrite = replyFile.WriteOemString( szOemKludge );
				}
			}
			// write INTL kludge
			if (fSuccessWrite) {
				sprintf( szOemKludge, "\1INTL %hu:%hu/%hu %hu:%hu/%hu%c",
					m_addrFrom.Zone, m_addrFrom.Net, m_addrFrom.Node,
					m_addrTo.Zone, m_addrTo.Net, m_addrTo.Node,
					0x0D );
				fSuccessWrite = replyFile.WriteOemString( szOemKludge );
			}
			// write FLAGS kludge
			if (fSuccessWrite && wReplyFlags != 0) {
				strcpy( szOemKludge, "\1FLAGS" );
				if (wReplyFlags & FLAG_DIRECT) {
					strcat( szOemKludge, " " );
					strcat( szOemKludge, "DIR" );
				}
				if (wReplyFlags & FLAG_IMMEDIATE) {
					strcat( szOemKludge, " " );
					strcat( szOemKludge, "IMM" );
				}
				if (wReplyFlags & FLAG_KILL_FILE_SENT) {
					strcat( szOemKludge, " " );
					strcat( szOemKludge, "KFS" );
				}
				if (wReplyFlags & FLAG_TRUNCATE_FILE) {
					strcat( szOemKludge, " " );
					strcat( szOemKludge, "TFS" );
				}
				if (wReplyFlags & FLAG_LOCK) {
					strcat( szOemKludge, " " );
					strcat( szOemKludge, "LOK" );
				}
				if (wReplyFlags & FLAG_CONFIRM_REQ) {
					strcat( szOemKludge, " " );
					strcat( szOemKludge, "CFM" );
				}
				// add 0x0D
				szOemKludge[strlen(szOemKludge)+1] = '\0';
				szOemKludge[strlen(szOemKludge)] = 0x0D;
				fSuccessWrite = replyFile.WriteOemString( szOemKludge );
			}
			// write MSGID: kludge
			if (fSuccessWrite) {
				if (m_addrTo.Point != 0) {
					sprintf( szOemKludge, "\01MSGID: %hu:%hu/%hu.%hu@%s %0lx%c",
						m_addrTo.Zone, m_addrTo.Net, m_addrTo.Node,
						m_addrTo.Point, m_addrTo.Domain,
						m_MsgIdHandler.Get(), 0x0D
					);
				}
				else {
					sprintf( szOemKludge, "\01MSGID: %hu:%hu/%hu@%s %0lx%c",
						m_addrTo.Zone, m_addrTo.Net, m_addrTo.Node,
						m_addrTo.Domain, m_MsgIdHandler.Get(), 0x0D
					);
				}
				fSuccessWrite = replyFile.WriteOemString( szOemKludge );
			}
			// write REPLY: kludge
			if (fSuccessWrite && *m_szMsgIdLine) {
				lstrcpy( szKludge, _T("\01REPLY: ") );
				lstrcat( szKludge, m_szMsgIdLine );
				szKludge[lstrlen(szKludge)+1] = _T('\0');
				szKludge[lstrlen(szKludge)]   = _T('\r');
				fSuccessWrite = replyFile.WriteStringAsOem( szKludge );
			}
			// write DOMAIN kludge
			if (fSuccessWrite && lstrcmpi(m_addrTo.Domain, m_addrFrom.Domain) != 0) {
				_stprintf( szKludge, _T("\1DOMAIN %s %hu:%hu/%hu.%hu %s %hu:%hu/%hu.%hu%c"),
					m_addrFrom.Domain, m_addrFrom.Zone, m_addrFrom.Net, m_addrFrom.Node, m_addrFrom.Point,
					m_addrTo.Domain, m_addrTo.Zone, m_addrTo.Net,
					m_addrTo.Node, m_addrTo.Point, 0x0D );
				fSuccessWrite = replyFile.WriteStringAsOem( szKludge );
			}

			szOemKludge[0] = 0x0D;

			// write body lines

			// write splitted message head
			if (nNumberOfMessages > 1) {
				sprintf( szLine, szSplittedMsgHead, nMessage, nNumberOfMessages );
				fSuccessWrite = replyFile.WriteOemString( szLine );
				if (fSuccessWrite) {
					fSuccessWrite = replyFile.Write( szOemKludge, 1 );
				}
			}

			if ((nKBytesLimit == 0) && (nLinesLimit == 0)) {
				// no limit
				// write message at once
				for (; fSuccessWrite && it != vBodyLines.end(); it++) {
					// write next line
					if (!(*it).empty())
						fSuccessWrite = replyFile.WriteStringAsOem( (*it).c_str() );
					if (fSuccessWrite) {
						fSuccessWrite = replyFile.Write( szOemKludge, 1 );
					}
				}
			}
			else {
				if (it != vBodyLines.end()) {
					// write 1-st line
					if (!(*it).empty())
						fSuccessWrite = replyFile.WriteStringAsOem( (*it).c_str() );
					if (fSuccessWrite) {
						fSuccessWrite = replyFile.Write( szOemKludge, 1 );
					}
					nNumberOfLines = viLinesPerLine[nLine];
					nBodySize      = viLineLengths[nLine];
					nLine++;
					it++;
					for (; fSuccessWrite && it != vBodyLines.end(); it++, nLine++) {
						nBodySize      += viLineLengths[nLine];
						nNumberOfLines += viLinesPerLine[nLine];
						if (nKBytesLimit > 0 && nBodySize > nKBytesLimit) {
							break;
						}
						else
						if (nLinesLimit > 0 && nNumberOfLines > nLinesLimit) {
							break;
						}
						// write next line
						if (!(*it).empty())
							fSuccessWrite = replyFile.WriteStringAsOem( (*it).c_str() );
						if (fSuccessWrite) {
							fSuccessWrite = replyFile.Write( szOemKludge, 1 );
						}
					}
				}

				// write splitted message tail
				if (nNumberOfMessages > 1 && nMessage < nNumberOfMessages) {
					sprintf( szLine, szSplittedMsgTail, nMessage, nNumberOfMessages );
					fSuccessWrite = replyFile.WriteOemString( szLine );
					if (fSuccessWrite) {
						fSuccessWrite = replyFile.Write( szOemKludge, 1 );
					}
				}
			}

			// write tearline
			if (fSuccessWrite) {
				fSuccessWrite = replyFile.WriteStringAsOem( g_vars.m_szTearLine );
			}
			// write zero byte
			if (fSuccessWrite) {
				szOemKludge[0] = '\0';
				fSuccessWrite = replyFile.Write( szOemKludge, 1 );
			}
			replyFile.Close();
			nMessage++;
		}
		else {
			g_vars.m_log << _T("Failed to create ") << szReplyFileName << _T("\n");
		}
	} while (fSuccessWrite && (it != vBodyLines.end()));

	// free memory
	delete [] szSplittedMsgSubj;
	delete [] szSplittedMsgHead;
	delete [] szSplittedMsgTail;
	delete [] szOemSubject;
}

bool CMsg::SaveAsReceived() {
	if (m_hFile != INVALID_HANDLE_VALUE) {
		// the file is already opened
		if (SetFilePointer( m_hFile, 0, NULL, FILE_BEGIN ) == 0xFFFFFFFF)
			// failed
			return (false);
	}
	else {
		// open file
		m_hFile = CreateFile( m_szMsgFileName, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL );
		if (m_hFile == INVALID_HANDLE_VALUE)
			// failed
			return (false);
	}
    
	m_Header.m_wAttrs |= ATTR_RECEIVED;
	DWORD	dwBytesWritten;
	BOOL	bResult = WriteFile( m_hFile, &m_Header, sizeof(m_Header), &dwBytesWritten, NULL);
	CloseFile();
	return (bResult == TRUE);
}
